<?php

namespace Albedo\Notification\Notifications;

use Albedo\Notification\Channels\SmsChannel;
use Albedo\Notifications\Channels\MobilePushChannel;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Kreait\Firebase\Messaging\CloudMessage;
use Kreait\Firebase\Messaging\Notification as FcmNotification;

class TestNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct()
    {
    }

    public function via($notifiable): array
    {
        return [
            'mail',
            'database',
            SmsChannel::class,
            MobilePushChannel::class
        ];
    }

    public function toMail($notifiable): MailMessage
    {
        return (new MailMessage)
            ->line('EMAIL message works.');
    }

    public function toSms($notifiable): string
    {
        return sprintf('SMS message works - %s.', config('app.name'));
    }

    public function toDatabase($notifiable): array
    {
        return [];
    }

    public function toMobilePush()
    {
        return CloudMessage::new()
            ->withNotification(
                FcmNotification::create(
                    config('app.name') . ' - Test',
                    'Push mobile działa poprawnie 🙌',
                    url('public/Favicon_120x120.png')
                )
            );
    }

    public function toArray($notifiable): array
    {
        return [];
    }
}
