<?php

namespace Albedo\Notification\Http\Controllers;

use Albedo\Notification\Http\Requests\FirebaseCloudMessageTokenRequest;
use Albedo\Notification\Models\FirebaseCloudMessageToken;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Response;

class StoreFirebaseCloudMessageTokenController extends Controller
{
    public function __invoke(FirebaseCloudMessageTokenRequest $request)
    {
        try {
            $token = $request->token;
            $user = auth()->user();

            $firebaseCloudMessageToken = FirebaseCloudMessageToken::create([
                'user_id' => $user->id,
                'token' => $token,
            ]);

            return Response::success(
                message: __('The fcm token has been saved.'),
            );

        } catch (\Exception $exception) {
            report($exception);
            return Response::error(
                message: __('An error occurred while saving the FCM token. Please try again later. If the problem persists, contact the Organizer.'),
            );
        }
    }
}
