<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('firebase_cloud_message_tokens', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(config('notification.user_model'))->constrained()->cascadeOnDelete();
            $table->text('token');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('firebase_cloud_message_tokens');
    }
};
