<?php

namespace Albedo\Notification\Traits;

use Albedo\Notification\Contracts\GroupNotificationInterface;
use Albedo\Notification\Models\NotificationPreferenceDisable;
use Illuminate\Contracts\Auth\Authenticatable;
use ReflectionClass;

trait ResolvesNotificationPreferences
{
    public function via($notifiable): array
    {
        return $this->filterViaPreferences($notifiable, $this->preferenceChannels());
    }

    /*
     * Kanały
     * Grupy
     */
    protected function filterViaPreferences(
        $notifiable,
        array $channels
    ): array {

        if (! $notifiable instanceof Authenticatable) {
            return $channels;
        }

        if ($this->isEnabled($notifiable, static::class)) {
            return [];
        }

        return collect($channels)
            ->reject(fn(string $channelClass) => $this->isDisabled($notifiable, $channelClass))
            ->values()
            ->toArray();
    }

    protected function isDisabled(
        Authenticatable $user,
        string $class
    ): bool {
        return NotificationPreferenceDisable::query()
            ->where('user_id', $user->getAuthIdentifier())
            ->where('class', $class)
            ->exists();
    }


}
