<?php

namespace Albedo\Notification\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class FirebaseCloudMessageTokenRequest extends FormRequest
{
    public function authorize(): bool
    {
        return Auth::user()->currentAccessToken()?->name === 'mobile';
    }

    public function rules(): array
    {
        return [
            'token' => 'required|string|max:255|min:12',
        ];
    }

}
