<?php

use Albedo\Notification\Channels\MobilePushChannel;
use Albedo\Notification\Channels\SmsChannel;
use Albedo\Notification\Groups\BaseGroupNotification;
use Albedo\Notification\Notifications\TestNotification;
use Illuminate\Notifications\Channels\DatabaseChannel;
use Illuminate\Notifications\Channels\MailChannel;

return [


    'user_model' => App\Models\User::class,

    'route' => [

        'as' => 'notification.',

        'prefix' => 'api/notification',

        'middleware' => [
            \Illuminate\Routing\Middleware\SubstituteBindings::class,
            'auth:sanctum'
        ],
    ],

    'sms' => [

        'token' => env('SMS_API_TOKEN'),

        'from' => env('SMS_API_FROM'),

        'test' => env('SMS_API_TEST', 0),
    ],


    'preferences' => [
        'channels' => [
            MailChannel::class => [
                'type' => 'channel',
                'label' => 'E-mail',
                'description' => 'I agree to receive programme notifications via e-mail to the e-mail address provided during programme registration.',
                'order' => 1,
                'editable' => true,
                'hidden' => false,
            ],
            SmsChannel::class => [
                'type' => 'channel',
                'label' => 'SMS',
                'description' => 'I agree to receive programme notifications via text message to the mobile number provided during programme registration.',
                'order' => 2,
                'editable' => true,
                'hidden' => false,
            ],
            MobilePushChannel::class => [
                'type' => 'channel',
                'label' => 'Notifications in the mobile app',
                'description' => 'I agree to receive push notifications about the programme on my device.',
                'order' => 3,
                'editable' => true,
                'hidden' => false,
            ],
            DatabaseChannel::class => [
                'type' => 'channel',
                'label' => 'Notifications in the website',
                'order' => 4,
                'editable' => false,
                'hidden' => true,
            ],
        ],

        'groups' => [
            BaseGroupNotification::class => [
                'type' => 'group',
                'label' => 'Base',
                'order' => 1,
                'editable' => true,
                'hidden' => false,
                'notifications' => [
                    TestNotification::class => [
                        'type' => 'notification',
                        'label' => 'Testowe powiadomienie',
                        'group' => BaseGroupNotification::class,
                        'order' => 1,
                        'editable' => true,
                        'hidden' => false,
                    ],
                ]
            ],
        ],

        'notifications' => [
            TestNotification::class => [
                'type' => 'notification',
                'label' => 'Testowe powiadomienie',
                'group' => BaseGroupNotification::class,
                'order' => 1,
                'editable' => true,
                'hidden' => false,
            ],
        ],
    ]

];
