<?php

namespace Albedo\Notification;

use Albedo\Notification\Console\Commands\SendTestNotificationCommand;
use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;

class NotificationServiceProvider extends PackageServiceProvider
{
    public function configurePackage(Package $package): void
    {
        /*
         * This class is a Package Service Provider
         *
         * More info: https://github.com/spatie/laravel-package-tools
         */
        $package
            ->name('notification')
            ->hasConfigFile()
            ->hasViews()
            ->hasRoute('notification')
            ->hasMigration('2025_01_27_131147_create_notifications_table')
            ->hasMigration('2025_12_10_095731_create_firebase_cloud_message_tokens_table')
            ->runsMigrations()
            ->hasCommand(SendTestNotificationCommand::class);
    }
}
