<?php

use Albedo\Notification\Http\Controllers\CounterNotificationController;
use Albedo\Notification\Http\Controllers\ListReadNotificationController;
use Albedo\Notification\Http\Controllers\ListTypeNotificationController;
use Albedo\Notification\Http\Controllers\ListUnreadNotificationController;
use Albedo\Notification\Http\Controllers\ReadNotificationController;
use Albedo\Notification\Http\Controllers\StoreFirebaseCloudMessageTokenController;
use Illuminate\Support\Facades\Route;

Route::group([
     'as' => config('notification.route.as', 'notification.'),
    'prefix' => config('notification.route.prefix', 'api/notification'),
    'middleware' => config('notification.route.middleware'),
], function () {
    Route::get('unread', ListUnreadNotificationController::class)->name('unread');
    Route::get('read', ListReadNotificationController::class)->name('read');
    Route::post('read', ReadNotificationController::class)->name('mark-as-read');
    Route::get('counter', CounterNotificationController::class)->name('counter');
    Route::get('types', ListTypeNotificationController::class)->name('types');
});

Route::group([
    'prefix' => 'api/fcm',
    'as' => 'fcm.',
    'middleware' => config('notification.route.middleware'),
], function () {
    Route::post('token', StoreFirebaseCloudMessageTokenController::class)->name('store-token');
});
