<?php

namespace App\Http\Controllers\Notification;

use Albedo\Notification\Http\Requests\NotificationGroupRequest;
use Albedo\Notification\Resources\NotificationResource;
use App\Http\Controllers\Controller;
use Exception;
use Illuminate\Support\Facades\Response;

class ListUnreadNotificationController extends Controller
{

    /**
     * List unread notifications
     *
     * This endpoint returns a list of unread notifications for the current user.
     *
     * You can filter notifications by category by passing the "category" parameter.
     *
     * @group Notification
     */
    public function __invoke(NotificationGroupRequest $request)
    {
        $group = $request->input('group');

        $user = auth()->user();

        try {
            $notifications = $user
                ->unreadNotifications()
                ->when($group, fn($q) => $q->where('group', $group))
                ->get();

            return Response::success(data: NotificationResource::collection($notifications), message: "Success");
        } catch (Exception $e) {
            report($e);
            return Response::generalError();
        }
    }
}
