<?php

namespace App\Http\Controllers\Notification;

use App\Http\Controllers\Controller;
use Exception;
use Illuminate\Support\Facades\Response;

class ListTypeNotificationController extends Controller
{
    /**
     * Categories notifications.
     *
     * @group Notification
     */
    public function __invoke()
    {
        try {
            $groups = collect(config('notification.default-groups'));
            return Response::success(data: $groups, message: "Notifications types retrieved successfully");
        } catch (Exception $e) {
            report($e);
            return Response::generalError();
        }
    }
}
