<?php

namespace App\Http\Controllers\Notification;

use Albedo\Notification\Models\Notification;
use App\Http\Controllers\Controller;
use Exception;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Response;

class CounterNotificationController extends Controller
{

    /**
     * Counter unread notifications
     *
     * This endpoint returns the count of unread notifications for the current user.
     *
     * @group Notification
     */
    public function __invoke()
    {
        try {
            $notifications = $this->getNotificationsByTypeWithUnreadCount();
            return Response::success(data: $notifications, message: "");
        } catch (Exception $e) {
            report($e);
            return Response::generalError();
        }
    }

    /**
     * @return Collection
     */
    private function getNotificationsByTypeWithUnreadCount(): Collection
    {
        $user = auth()->user();

        $result = $user
            ->notifications()
            ->selectRaw('max(group) as group, count(*) as count')
            ->whereNull('read_at')
            ->groupBy('group')
            ->get()
            ->keyBy(fn(Notification $notification) => $notification->group)
            ->map(fn($group) => $group->count);

        return collect(config('notification.default-groups'))
            ->mapWithKeys(fn(string $group) => [$group => 0])
            ->merge($result);
    }
}
