<?php

use App\Http\Controllers\Notification\CounterNotificationController;
use App\Http\Controllers\Notification\ListReadNotificationController;
use App\Http\Controllers\Notification\ListTypeNotificationController;
use App\Http\Controllers\Notification\ListUnreadNotificationController;
use App\Http\Controllers\Notification\ReadNotificationController;

Route::group([
    'as' => config('notification.route.as'),
    'prefix' => config('notification.route.prefix', 'api/notification'),
    'middleware' => config('notification.route.middleware'),
], function () {
    Route::get('unread', ListUnreadNotificationController::class)->name('unread');
    Route::get('read', ListReadNotificationController::class)->name('read');
    Route::post('read', ReadNotificationController::class)->name('mark-as-read');
    Route::get('counter', CounterNotificationController::class)->name('counter');
    Route::get('groups', ListTypeNotificationController::class)->name('groups');
});
