<?php

namespace Notification\Notification;

use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;
use Notification\Notification\Commands\NotificationCommand;

class NotificationServiceProvider extends PackageServiceProvider
{
    public function configurePackage(Package $package): void
    {
        /*
         * This class is a Package Service Provider
         *
         * More info: https://github.com/spatie/laravel-package-tools
         */
        $package
            ->name('notification')
            ->hasConfigFile()
            ->hasViews()
            ->hasMigration('create_notification_table')
            ->hasCommand(NotificationCommand::class);
    }
}
