<?php

namespace Albedo\Notification\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\DatabaseNotification;

class Notification extends DatabaseNotification
{
    use HasFactory;

    protected $casts = [
        'data' => 'array',
        'read_at' => 'datetime'
    ];

    public function getFrontendRouteName()
    {
        return $this->data['route-frontend'] ?? null;
    }

    protected static function boot(): void
    {
        parent::boot();

        static::creating(function ($notification) {
            $notification->group = $notification->data['group'] ?? null;
        });
    }

}
