<?php

namespace Albedo\Notification\Http\Controllers;

use Albedo\Notification\Http\Requests\Requests\NotificationGroupRequest;
use Albedo\Notification\Resources\NotificationResource;
use Exception;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Response;

class ListReadNotificationController extends Controller
{

    /**
     * List read notifications
     *
     * This endpoint returns a list of read notifications for the current user.
     *
     * You can filter notifications by category by passing the "category" parameter.
     *
     * @group Notification
     */
    public function __invoke(NotificationGroupRequest $request)
    {
        $group = $request->input('group');

        try {
            $user = auth()->user();
            $notifications = $user
                ->readNotifications()
                ->when($group, fn($q) => $q->where('group', $group))
                ->get();
            return Response::success(data: NotificationResource::collection($notifications));
        } catch (Exception $e) {
            report($e);
            return Response::generalError();
        }
    }
}
