<?php

namespace Albedo\Notification\Http\Controllers;

use Albedo\Notification\Notification;
use Exception;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Response;

class CounterNotificationController extends Controller
{

    /**
     * Counter unread notifications
     *
     * This endpoint returns the count of unread notifications for the current user.
     *
     * @group Notification
     */
    public function __invoke()
    {
        try {
            $notifications = $this->getNotificationsByTypeWithUnreadCount();
            return Response::success(data: $notifications);
        } catch (Exception $e) {
            report($e);
            return Response::generalError();
        }
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    private function getNotificationsByTypeWithUnreadCount(): \Illuminate\Support\Collection
    {
        $groups = config('notification.groups');
        $user = auth()->user();

        $result = $user
            ->notifications()
            ->selectRaw('max(group) as group, count(*) as count')
            ->whereNull('read_at')
            ->groupBy('group')
            ->get()
            ->keyBy(fn(Notification $notification) => $notification->group)
            ->map(fn($group) => $group->count);

        return collect($groups)
            ->mapWithKeys(fn(string $group) => [$group => 0])
            ->merge($result);
    }
}
