<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {

        Schema::create('notification_preference_disables', function (Blueprint $table) {
            $userModel = config('notification.user_model');
            $foreignKey = (new $userModel)->getForeignKey();

            $table->id();
            $table->foreignIdFor($userModel)->constrained()->cascadeOnDelete();
            $table->string('class');
            $table->boolean('enabled');
            $table->timestamps();
            $table->unique([$foreignKey, 'class']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('notification_preferences');
    }
};
