<?php

namespace Albedo\LogAlert;

use Illuminate\Support\ServiceProvider;

class LogAlertServiceProvider extends ServiceProvider
{
    public function boot()
    {
        $this->publishes([
            __DIR__ . '/../config/logalert.php' => config_path('logalert.php'),
        ], 'log-alert-config');

        $this->mergeConfigFrom(
            __DIR__ . '/../config/logalert.php',
            'logalert'
        );

        $this->app['router']->aliasMiddleware(
            'logalert.check.db',
            \Albedo\LogAlert\Http\Middleware\CheckDatabaseConnection::class
        );

        $this->app->booted(function () {
            $kernel = $this->app->make(\Illuminate\Contracts\Http\Kernel::class);
            $kernel->pushMiddleware(\Albedo\LogAlert\Http\Middleware\CheckDatabaseConnection::class);
        });
    }

    public function register()
    {
        //
    }
}
