<?php

namespace AlbedoDevs\LogAlert\Services;

use App\Jobs\LogAlertJob;
use Exception;

class LogAlert
{
    public static function criticalFrontend(
        string  $exception,
        ?string $bodyRequest = null
    ): void
    {
        LogAlert::set(
            partOfApplication: 'Frontend',
            priority: 'critical',
            exception: $exception,
            bodyRequest: $bodyRequest
        );
    }

    public static function criticalBackend(
        Exception $exception,
        ?string   $bodyRequest = null
    ): void
    {
        LogAlert::set(
            partOfApplication: 'Backend',
            priority: 'critical',
            message: $exception->getMessage(),
            exception: $exception,
            bodyRequest: $bodyRequest
        );
    }

    public static function midFrontend(
        string  $exception,
        ?string $bodyRequest = null
    ): void
    {
        LogAlert::set(
            partOfApplication: 'Frontend',
            priority: 'mid',
            exception: $exception,
            bodyRequest: $bodyRequest
        );
    }

    public static function midBackend(
        Exception $exception,
        ?string   $bodyRequest = null
    ): void
    {
        LogAlert::set(
            partOfApplication: 'Backend',
            priority: 'mid',
            message: $exception->getMessage(),
            exception: $exception,
            bodyRequest: $bodyRequest
        );
    }

    public static function lowFrontend(
        string  $exception,
        ?string $bodyRequest = null
    ): void
    {
        LogAlert::set(
            partOfApplication: 'Frontend',
            priority: 'low',
            exception: $exception,
            bodyRequest: $bodyRequest
        );
    }

    public static function lowBackend(
        Exception $exception,
        ?string   $bodyRequest = null
    ): void
    {
        LogAlert::set(
            partOfApplication: 'Backend',
            priority: 'low',
            message: $exception->getMessage(),
            exception: $exception,
            bodyRequest: $bodyRequest
        );
    }

    private static function set(
        string  $partOfApplication,
        string  $priority,
        ?string $message = null,
        string  $exception,
        ?string $bodyRequest = null
    ): void
    {
        $logAlertUrl = config('logalert.url');
        $uniqueKey = config('logalert.unique_key');
        if (
            null !== $uniqueKey
            && null !== $logAlertUrl
        ) {
            dispatch(new LogAlertJob(
                uniqueKey: $uniqueKey,
                logAlertUrl: $logAlertUrl,
                partOfApplication: $partOfApplication,
                priority: $priority,
                message: $message,
                exception: $exception,
                backtrace: LogAlert::logCallerInfo(),
                bodyRequest: $bodyRequest
            ));
        }
    }

    private static function logCallerInfo(): string
    {
        $trace = debug_backtrace();
        $caller = $trace[3];

        $file = $caller['file'] ?? 'nieznany plik';
        $line = $caller['line'] ?? 'nieznana linia';
        $class = $caller['class'] ?? null;
        $function = $caller['function'] ?? 'nieznana funkcja';

        return sprintf(
            "Wywołane w: %s w pliku %s na linii %s.",
            ($class ? "$class::$function" : $function),
            $file,
            $line
        );
    }
}
