<?php

namespace Albedo\LogAlert\Jobs;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Bus\Queueable;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class LogAlertJob implements ShouldQueue
{
    use Queueable;

    public function __construct(
        protected string $uniqueKey,
        protected string $logAlertUrl,
        protected string $partOfApplication,
        protected string $priority,
        protected string $message,
        protected string $exception,
        protected string $backtrace,
        protected ?string $bodyRequest = null
    )
    {
    }

    public function handle(): void
    {
        try {
            $result = Http::withHeaders([
                'X-Unique-Key' => $this->uniqueKey,
                'X-Requested-With' => 'XMLHttpRequest'
            ])->post($this->logAlertUrl, [
                'part_of_application' => $this->partOfApplication,
                'priority' => $this->priority,
                'message' => $this->message,
                'exception' => $this->exception,
                'backtrace' => $this->backtrace,
                'body_request' => $this->bodyRequest
            ]);

            if (in_array($result['code'] ?? null, [400, 404])) {
                Log::error($result);
            }
        } catch (\Exception $exception) {
            Log::info('Something wrong with set log to logAlert');
            Log::error($exception->getMessage());
        }
    }
}
