<?php

namespace Albedo\LogAlert\Http\Middleware;

use Albedo\LogAlert\Services\LogAlert;
use Closure;
use PDOException;
use Illuminate\Support\Facades\DB;

class CheckDatabaseConnection
{
    public function handle($request, Closure $next)
    {
        try {
            DB::connection()->getPdo();
        } catch (PDOException $exception) {
            LogAlert::criticalBackend($exception);
        }

        return $next($request);
    }
}
