<?php

namespace Albedo\LogAlert\Jobs;

use Albedo\LogAlert\Services\LogAlert;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Bus\Queueable;
use Throwable;

class LogAlertJob implements ShouldQueue
{
    use Queueable;

    public function __construct(
        protected string            $uniqueKey,
        protected string            $logAlertUrl,
        protected string            $partOfApplication,
        protected string            $priority,
        protected string            $message,
        protected string|Throwable $throwable,
        protected string            $backtrace,
        protected ?string           $bodyRequest = null
    )
    {
    }

    public function handle(): void
    {
        LogAlert::sendToDevinci(
            uniqueKey: $this->uniqueKey,
            logAlertUrl: $this->logAlertUrl,
            partOfApplication: $this->partOfApplication,
            priority: $this->priority,
            message: $this->message,
            throwable: (string)$this->throwable,
            backtrace: $this->backtrace,
            bodyRequest: $this->bodyRequest
        );
    }
}
