<?php

namespace Albedo\Gamification\Services;

use Albedo\Auth\Services\User;
use Albedo\Gamification\Models\Agreement;
use Albedo\Gamification\Models\Document;

class AgreementService
{
    public static function prepareAgreementsList(): array
    {
        $agreements = Agreement::all();

        return $agreements->map(function (Agreement $agreement, $key) {
            return [
                'key' => $agreement->agreement_key,
                'must_be_accepted' => $agreement->required,
                'text' => $agreement->parsed_text,
                'label' => $agreement->label,
            ];
        })
            ->toArray();
    }

    public function saveAgreementsForUser(User $user, array $agreements): void
    {
        $user->update([
            'agreements' => $agreements
        ]);
    }
}
