<?php

namespace Albedo\Gamification\Database\Seeders;

use Albedo\Gamification\Models\Avatar;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\File;

class AvatarSeeder extends Seeder
{
    public function run(): void
    {
        $files = File::files(storage_path('app/seeders/avatars'));
        foreach ($files as $file) {
            $avatar = Avatar::updateOrCreate([
                'name' => pathinfo($file, PATHINFO_FILENAME),
            ]);

            $avatar->clearMediaCollection('avatar');
            $avatar->addMedia($file->getRealPath())
                ->preservingOriginal()
                ->toMediaCollection('avatar');
        }
    }
}
