<?php

namespace Albedo\Gamification\Models;

use App\Models\Traits\Uuid;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Str;

class Agreement extends Model
{
    protected $guarded = [];

    public function getAgreementKey(): string
    {
        return Str::of($this->name)
            ->prepend('agreement_')
            ->slug('_')
            ->toString();
    }

    public function parsedText(): Attribute
    {
        return Attribute::make(
            get: fn() => $this->parse($this->text)
        );
    }

    private function parse(string $text): string
    {
        $agreements = ProgramFile::with(['media', 'fileType'])
            ->get();

        $links = $agreements
            ->mapWithKeys(fn(ProgramFile $programFile) => [
                $programFile->fileType->slug => $programFile->url
                    ?: $programFile->getFirstMediaUrl('rule')
            ])
            ->toArray();

        $pattern = '/\[([^\]]+)\]\(\s*\{\{\s*([^}\s]+)\s*\}\}\s*\)/u';

        return preg_replace_callback($pattern, function ($m) use ($links) {
            $text = $m[1];
            $key = $m[2];

            $href = $links[$key] ?? '#';

            $labelEsc = htmlspecialchars($text, ENT_QUOTES, 'UTF-8');
            $hrefEsc = htmlspecialchars($href, ENT_QUOTES, 'UTF-8');

            return "<a data-target=\"_blank\" href=\"{$hrefEsc}\">{$labelEsc}</a>";
        }, $text);
    }

    public function userAgreement(): HasMany
    {
        return $this->hasMany(UserAgreement::class);
    }
}
