<?php


use Albedo\Gamification\Http\Controllers\AgreementAction;
use Albedo\Gamification\Http\Controllers\AttachmentAction;
use Albedo\Gamification\Http\Controllers\AttachmentHtmlAction;
use Albedo\Gamification\Http\Controllers\AvatarAction;
use Albedo\Gamification\Http\Controllers\FaqAction;
use Albedo\Gamification\Http\Controllers\ModulesAction;
use Albedo\Gamification\Http\Controllers\RuleAction;
use Albedo\Gamification\Http\Controllers\UpdateAvatarAction;

Route::group([
    'as' => config('gamification.route.as', 'gamification.'),
    'prefix' => config('gamification.route.prefix', 'api'),
], function () {

    Route::get('module-settings', ModulesAction::class)->name('module-settings');
    Route::get('agreements', AgreementAction::class)->name('agreements');
    Route::get('attachments', AttachmentAction::class)->name('attachments');
    Route::get('attachment-html/{slug}', AttachmentHtmlAction::class)->name('attachment-html');
    Route::get('avatars', AvatarAction::class)->name('avatars');

    Route::group([
        'middleware' => config('gamification.route.middleware'),
    ], function () {
        Route::patch('avatar', UpdateAvatarAction::class)->name('update-avatar');

        Route::get('rule', RuleAction::class)->name('rule');

        Route::get('faq', FaqAction::class)->name('faq');
    });
});

