<?php

namespace Albedo\Gamification\Http\Resources;

use Albedo\Gamification\Models\FaqItem;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin FaqItem */
class FaqItemResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'question' => $this->question,
            'answer' => $this->answer,

            'faq' => new FaqResource($this->whenLoaded('faq')),
        ];
    }
}
