<?php

namespace Albedo\Gamification\Http\Controllers;


use Illuminate\Support\Facades\Auth;
use Albedo\Gamification\Http\Resources\FaqResource;
use Albedo\Gamification\Models\Faq;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Response;

class FaqAction extends Controller
{
    public function __invoke()
    {
        $user = Auth::user();
        $user->load('roles');

        $faqContent = Faq::query()
            ->with(['faqItems' => fn($q) => $q->orderBy('order')])
            ->where(fn($q) => $q
                ->whereHas('roles', fn($q) => $q->whereIn('name', $user->roles->pluck('name')->toArray()))
                ->orWhereDoesntHave('roles'))
            ->latest()
            ->first();

        return Response::success(data: !$faqContent ? (object)[] : FaqResource::make($faqContent));
    }
}
