<?php

namespace Albedo\Gamification\Tests;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Orchestra\Testbench\TestCase as Orchestra;

abstract class TestCase extends Orchestra
{

    protected function setUp(): void
    {
        parent::setUp();

        $this->setUpDatabase();
    }

    protected function getEnvironmentSetUp($app)
    {
        $app['config']->set('albedo-auth.user_model', \Albedo\Gamification\Tests\Models\User::class);
        $app['config']->set('gamification.user_model', \Albedo\Gamification\Tests\Models\User::class);
        $app['config']->set('auth.providers.users.model', \Albedo\Gamification\Tests\Models\User::class);
    }

    protected function getPackageProviders($app): array
    {
        return [
            \Laravel\Sanctum\SanctumServiceProvider::class,
            \Albedo\Gamification\GamificationServiceProvider::class,
            \Spatie\LaravelSettings\LaravelSettingsServiceProvider::class,
        ];
    }

    private function setUpDatabase()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('first_name');
            $table->string('last_name');
            $table->string('email')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->rememberToken();
            $table->timestamps();
        });
    }

}


