<?php

namespace Albedo\Gamification\Tests\Models;

use Albedo\Gamification\Contracts\MustAcceptUserAgreements;
use Albedo\Gamification\Models\Traits\HasUserAgreements;
use Albedo\Gamification\Models\Traits\HasUserAvatar;
use Albedo\Gamification\Tests\factories\UserFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable implements MustAcceptUserAgreements
{
    use Notifiable,
        HasApiTokens,
        HasFactory,
        HasUserAgreements,
        HasUserAvatar;

    protected $guarded = [];

    protected static function newFactory()
    {
        return UserFactory::new();
    }
}
