<?php

namespace Albedo\Gamification\Settings;

use Filament\Auth\Pages\Register;
use Spatie\LaravelSettings\Settings;
use Carbon\Carbon;

class ModuleSettings extends Settings
{
    /**
     * Registration
     */
    public null|Carbon|string $registration_start_date = null;
    public null|Carbon|string $registration_end_date = null;

    /**
     * Login
     */
    public null|Carbon|string $login_start_date = null;
    public null|Carbon|string $login_end_date = null;

    /**
     * ELEARNING
     */
    public null|Carbon|string $elearning_start_date = null;
    public null|Carbon|string $elearning_end_date = null;

    /**
     * DUEL
     */
    public null|Carbon|string $duel_start_date = null;
    public null|Carbon|string $duel_end_date = null;

    /**
     * SPECIAL MISSION
     */
    public null|Carbon|string $special_mission_start_date = null;
    public null|Carbon|string $special_mission_end_date = null;

    /**
     * PLUG - BEGINNING OF PROGRAM
     */
    public null|Carbon|string $plug_beginning_of_program_start_date = null;
    public null|Carbon|string $plug_beginning_of_program_end_date = null;
    public null|Carbon|string $plug_beginning_of_program_title = null;
    public null|string $plug_beginning_of_program_content = null;

    /**
     * PLUG - ENDING OF PROGRAM
     */
    public null|Carbon|string $plug_ending_of_program_start_date = null;
    public null|Carbon|string $plug_ending_of_program_end_date = null;
    public null|Carbon|string $plug_ending_of_program_title = null;
    public null|string $plug_ending_of_program_content = null;

    /**
     * QUESTIONNAIRE
     */
    public null|Carbon|string $questionnaire_start_date = null;
    public null|Carbon|string $questionnaire_end_date = null;

    /**
     * VOTE
     */
    public null|Carbon|string $vote_start_date = null;
    public null|Carbon|string $vote_end_date = null;

    public static function group(): string
    {
        return 'modules';
    }

    public function listStatusModules()
    {
        return [
            'registration_enabled' => $this->isEnabled($this->registration_start_date, $this->registration_end_date),
            'login_enabled' => $this->isEnabled($this->login_start_date, $this->login_end_date),
            'elearning_enabled' => $this->isEnabled($this->elearning_start_date, $this->elearning_end_date),
            'duel_enabled' => $this->isEnabled($this->duel_start_date, $this->duel_end_date),
            'special_mission_enabled' => $this->isEnabled($this->special_mission_start_date, $this->special_mission_end_date),
            'questionnaire_enabled' => $this->isEnabled($this->questionnaire_start_date, $this->questionnaire_end_date),
            'vote_enabled' => $this->isEnabled($this->vote_start_date, $this->vote_end_date),
            'plug' => match (true) {
                $this->isEnabled($this->plug_beginning_of_program_start_date, $this->plug_beginning_of_program_end_date) => [
                    'enabled' => $this->isEnabled($this->plug_beginning_of_program_start_date, $this->plug_beginning_of_program_end_date),
                    'title' => $this->plug_beginning_of_program_title,
                    'content' => $this->plug_beginning_of_program_content,
                ],
                $this->isEnabled($this->plug_ending_of_program_start_date, $this->plug_ending_of_program_end_date) => [
                    'enabled' => $this->isEnabled($this->plug_ending_of_program_start_date, $this->plug_ending_of_program_end_date),
                    'title' => $this->plug_ending_of_program_title,
                    'content' => $this->plug_ending_of_program_content,
                ],
                default => [
                    'enabled' => false,
                    'title' => null,
                    'content' => null,
                ],
            },
        ];
    }

    public function isEnabled(null|Carbon|string $start, null|Carbon|string $end): bool
    {
        if (is_null($start) || is_null($end)) {

            if (is_null($start) && !is_null($end)) {
                return now()->gte($end);
            }

            if (is_null($end) && !is_null($start)) {
                return now()->lte($start);
            }

            return true;
        }

        return now()->between($start, $end);
    }
}
