<?php

namespace Albedo\Gamification\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProgramFilesResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'type' => $this->fileType->slug,
            'url' => $this->url ?: $this->getFirstMediaUrl('rule'),
            'url_html' => $this->getLastMediaUrl('rule_html'),
        ];
    }
}
