<?php

namespace Albedo\Gamification\Http\Controllers;

use Albedo\Gamification\Http\Resources\RuleResource;
use Albedo\Gamification\Models\Rule;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Response;

class RuleAction extends Controller
{
    public function __invoke()
    {
        $user = Auth::user();
        $user->load('roles');

        $ruleContent = Rule::query()
            ->with(['media'])
            ->where(fn($q) => $q
                ->whereHas('roles', fn($q) => $q->whereIn('name', $user->roles->pluck('name')->toArray()))
                ->orWhereDoesntHave('roles'))
            ->latest()
            ->first();

        return Response::success(data: $ruleContent ? RuleResource::make($ruleContent) : null);
    }
}
