<?php

namespace Albedo\Gamification\Filament\Pages;

use Albedo\Gamification\Settings\ModuleSettings;
use Filament\Forms\Components\DateTimePicker;
use Filament\Forms\Components\RichEditor;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Pages\SettingsPage;
use Filament\Schemas\Components\Fieldset;
use Filament\Schemas\Components\Section;
use Filament\Schemas\Components\Tabs;
use Filament\Schemas\Components\Tabs\Tab;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;

class ManageModuleSettings extends SettingsPage
{


    protected static ?string $navigationLabel = 'Moduły';

    protected static ?int $navigationSort = 3;

    protected static string $settings = ModuleSettings::class;

    protected static ?string $title = 'Moduły';

    protected static string|null|\UnitEnum $navigationGroup = 'Ustawienia';

    public function form(Schema $schema): Schema
    {
        return $schema
            ->components([

                Section::make('Rejestracja użytkownika')
                    ->description('Rejestracja użytkownika - widoczność modułu')
                    ->schema([
                        DateTimePicker::make('registration_start_date')
                            ->label('Data rozpoczęcia rejestracji'),
                        DateTimePicker::make('registration_end_date')
                            ->label('Data zakończenia rejestracji'),
                    ]),
                Section::make('Logowanie użytkownika')
                    ->description('Logowanie użytkownika - widoczność modułu')
                    ->schema([
                        DateTimePicker::make('login_start_date')
                            ->label('Data rozpoczęcia logowania'),
                        DateTimePicker::make('login_end_date')
                            ->label('Data zakończenia logowania'),
                    ]),
                Section::make('Elearning')
                    ->description('Elearning - widoczność modułu')
                    ->schema([
                        DateTimePicker::make('elearning_start_date')
                            ->label('Data rozpoczęcia e-learningu'),
                        DateTimePicker::make('elearning_end_date')
                            ->label('Data zakończenia e-learningu'),
                    ]),
                Section::make('Pojedynki')
                    ->description('Pojedynki - widoczność modułu')
                    ->schema([
                        DateTimePicker::make('duel_start_date')
                            ->label('Data rozpoczęcia pojedynków'),
                        DateTimePicker::make('duel_end_date')
                            ->label('Data zakończenia pojedynków'),
                    ]),
                Section::make('Misje specjalne')
                    ->description('Misje specjalne - widoczność modułu')
                    ->schema([
                        DateTimePicker::make('special_mission_start_date')
                            ->label('Data rozpoczęcia misji specjalnych'),
                        DateTimePicker::make('special_mission_end_date')
                            ->label('Data zakończenia misji specjalnych'),
                    ]),

                $this->plugComponent(),

            ]);
    }

    public function plugComponent()
    {

        return Section::make('Zaślepka programu')
            ->columnSpanFull()
            ->description('Blokuje dostęp do strony i wyświetl zaślepkę z tytułem oraz tekstem. Dodaj wersje dla startu i końca programu.')
            ->schema([
                Tabs::make('Tabs')
                    ->tabs([
                        Tab::make('Start programu')
                            ->columns(2)
                            ->schema([
                                DateTimePicker::make('plug_beginning_of_program_start_date')
                                    ->label('Data rozpoczęcia zaślepki'),
                                DateTimePicker::make('plug_beginning_of_program_end_date')
                                    ->label('Data zakończenia zaślepki'),
                                TextInput::make('plug_beginning_of_program_title')
                                    ->columnSpanFull()
                                    ->label('Tytuł wyświetlany na zaślepce'),
                                RichEditor::make('plug_beginning_of_program_content')
                                    ->columnSpanFull()
                                    ->label('Treść wyświetlana na zaślepce'),
                            ]),
                        Tab::make('Koniec programu')
                            ->columns(2)
                            ->schema([
                                DateTimePicker::make('plug_ending_of_program_start_date')
                                    ->label('Data rozpoczęcia zaślepki'),
                                DateTimePicker::make('plug_ending_of_program_end_date')
                                    ->label('Data zakończenia zaślepki'),
                                TextInput::make('plug_ending_of_program_title')
                                    ->columnSpanFull()
                                    ->label('Tytuł wyświetlany na zaślepce'),
                                RichEditor::make('plug_ending_of_program_content')
                                    ->columnSpanFull()
                                    ->label('Treść wyświetlana na zaślepce')
                            ]),
                    ]),
            ]);
    }
}

