<?php

namespace Albedo\Gamification\Filament\Faqs\Schemas;

use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Schemas\Schema;

class FaqForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('name')
                    ->required()
                    ->label('Nazwa'),
                Select::make('roles')
                    ->multiple()
                    ->relationship(name: 'roles', titleAttribute: 'name')
                    ->preload(),
                Repeater::make('items')
                    ->relationship('faqItems')
                    ->schema([
                        TextInput::make('question')->required(),
                        TextInput::make('answer')->required(),
                        Toggle::make('is_active')->default(true),
                    ])
                ->reorderableWithButtons()
                ->orderColumn('order')
            ])
            ->columns(1);
    }
}
