<?php

namespace Albedo\Gamification\Services;

use Albedo\Gamification\Contracts\HasAvatar;
use Illuminate\Http\Request;

class AvatarService
{
    public function assignAvatarFromRequest(HasAvatar $user, Request $request): void
    {
        $user->avatars()->attach($request->avatar_id);
    }

    public function getAvatarRules(): array
    {
        return [
            'avatar_id' => ['required', 'exists:avatars,id'],
        ];
    }
}
