<?php

namespace Albedo\Gamification\Rules;

use Albedo\Gamification\Models\Agreement;
use Closure;
use Illuminate\Contracts\Validation\ValidationRule;
use Illuminate\Support\Collection;

class DynamicAgreementRule implements ValidationRule
{
    public function __construct(protected Collection $agreements) {}
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        if (! $this->agreements->pluck(fn(Agreement $agreement) => $agreement->getAgreementKey())->contains($attribute)) {
            $fail("Pole {$attribute} nie jest poprawnym kluczem.");
        }

        if (! in_array($value, [0, 1, true, false], true)) {
            $fail("Wartość {$attribute} musi być logiczna.");
        }
    }
}
