<?php

namespace Albedo\Gamification\Models\Traits;

use Albedo\Gamification\Models\Avatar;
use Albedo\Gamification\Models\UserAvatar;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

trait HasUserAvatar
{
    public function avatars(): BelongsToMany
    {
        return $this->belongsToMany(Avatar::class, UserAvatar::class)
            ->withTimestamps();
    }
}
