<?php

namespace Albedo\Gamification\Models\Traits;

use Albedo\Gamification\Contracts\PeriodContract;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Carbon;

trait PeriodTrait
{
    public static function getNameColumn(): string
    {
        return 'name';
    }

    public static function getStartColumn(): string
    {
        return 'start';
    }

    public static function getEndColumn(): string
    {
        return 'end';
    }
    public static function getPeriodByDate(Carbon $dateTime): ?PeriodContract
    {
        return self::getPeriodByDateOrNull($dateTime);
    }

    public static function getPeriodByDateOrNull(Carbon $dateTime): ?PeriodContract
    {
        return self::query()
            ->where(self::getStartColumn(), '<=', $dateTime)
            ->where(self::getEndColumn(), '>=', $dateTime)
            ->first();
    }


    public static function getPreviousCurrent(): ?PeriodContract
    {
        return self::query()
            ->where(self::getEndColumn(), '<', now())
            ->orderBy(self::getEndColumn(), 'desc')
            ->first();
    }

    public static function getCurrent(): ?PeriodContract
    {
        return self::getPeriodByDate(now());
    }

    public static function getActive(): ?PeriodContract
    {
        return self::getCurrent()
            ?? self::getPreviousCurrent()
            ?? self::first();
    }

    public function isCurrent(): bool
    {
        return now()->between(
            $this->getAttribute(self::getStartColumn()),
            $this->getAttribute(self::getEndColumn())
        );
    }

    public function getSelectName(): string
    {
        return $this->getAttribute(self::getNameColumn());
    }

    public function getStartDate(): Carbon
    {
        return $this->getAttribute(self::getStartColumn());
    }

    public function getEndDate(): Carbon
    {
        return $this->getAttribute(self::getEndColumn());
    }

    public function scopeOnlyAvailable(Builder $query): void
    {
        $query->where(self::getStartColumn(), '<=', now());
    }
}
