<?php

namespace Albedo\Gamification\Http\Controllers;

use Albedo\Gamification\Http\Resources\ProgramFilesResource;
use Albedo\Gamification\Models\ProgramFile;
use Illuminate\Support\Facades\Response;

/**
 * Pobierz listę plików programu (załączników).
 *
 * Endpoint zwracający wszystkie pliki powiązane z programem.
 *
 * @response 200 {"data": [...]}
 */
class AttachmentAction
{
    /**
     * Zwraca wszystkie pliki programu dostępne dla użytkownika.
     *
     * @response 200 {"data": [...]}
     */
    public function __invoke()
    {
        $programFiles = ProgramFile::with(['media', 'fileType'])
            ->get();

        return Response::success(
            data: ProgramFilesResource::collection($programFiles)
       );
    }
}
