<?php

namespace Albedo\Gamification\Filament\Rules;

use Albedo\Gamification\Filament\Rules\Pages\CreateRuleContent;
use Albedo\Gamification\Filament\Rules\Pages\EditRuleContent;
use Albedo\Gamification\Filament\Rules\Pages\ListRules;
use Albedo\Gamification\Filament\Rules\Pages\ViewRuleContent;
use Albedo\Gamification\Filament\Rules\Schemas\RuleContentForm;
use Albedo\Gamification\Filament\Rules\Schemas\RuleContentInfolist;
use Albedo\Gamification\Filament\Rules\Tables\RulesTable;
use Albedo\Gamification\Models\Rule;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class RuleContentResource extends Resource
{
    protected static ?string $model = Rule::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedRectangleStack;

    public static function form(Schema $schema): Schema
    {
        return RuleContentForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return RuleContentInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return RulesTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListRules::route('/'),
            'create' => CreateRuleContent::route('/create'),
            'view' => ViewRuleContent::route('/{record}'),
            'edit' => EditRuleContent::route('/{record}/edit'),
        ];
    }
}
