<?php

namespace Albedo\Gamification\Models;

use App\Models\Point;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class PointPeriod extends Model
{
    use HasFactory;

    protected $guarded = [];

    const MORPH_PERIODABLE_NAME = 'periodable';

    public function point(): BelongsTo
    {
        return $this->belongsTo(Point::class);
    }

    public function periodable(): MorphTo
    {
        return $this->morphTo(self::MORPH_PERIODABLE_NAME);
    }
}
