<?php

namespace Albedo\Gamification\Filament\Avatars;

use Albedo\Gamification\Filament\Avatars\Pages\CreateAvatar;
use Albedo\Gamification\Filament\Avatars\Pages\EditAvatar;
use Albedo\Gamification\Filament\Avatars\Pages\ListAvatars;
use Albedo\Gamification\Filament\Avatars\Pages\ViewAvatar;
use Albedo\Gamification\Filament\Avatars\Schemas\AvatarForm;
use Albedo\Gamification\Filament\Avatars\Schemas\AvatarInfolist;
use Albedo\Gamification\Filament\Avatars\Tables\AvatarsTable;
use Albedo\Gamification\Models\Avatar;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class AvatarResource extends Resource
{
    protected static ?string $model = Avatar::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedUserCircle;

    public static function form(Schema $schema): Schema
    {
        return AvatarForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return AvatarInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return AvatarsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListAvatars::route('/'),
            'create' => CreateAvatar::route('/create'),
            'view' => ViewAvatar::route('/{record}'),
            'edit' => EditAvatar::route('/{record}/edit'),
        ];
    }
}
