<?php

namespace Albedo\Gamification\Filament\Attachments;

use Albedo\Gamification\Filament\Attachments\Pages\CreateAttachment;
use Albedo\Gamification\Filament\Attachments\Pages\EditAttachment;
use Albedo\Gamification\Filament\Attachments\Pages\ListAttachments;
use Albedo\Gamification\Filament\Attachments\Pages\ViewAttachment;
use Albedo\Gamification\Filament\Attachments\Schemas\AttachmentForm;
use Albedo\Gamification\Filament\Attachments\Schemas\AttachmentInfolist;
use Albedo\Gamification\Filament\Attachments\Tables\AttachmentsTable;
use Albedo\Gamification\Models\ProgramFile;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class AttachmentResource extends Resource
{
    protected static ?string $model = ProgramFile::class;

    protected static ?string $navigationLabel = 'Załączniki';

    protected static string|null|\UnitEnum $navigationGroup = 'Ustawienia';

    public static function form(Schema $schema): Schema
    {
        return AttachmentForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return AttachmentInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return AttachmentsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListAttachments::route('/'),
            'create' => CreateAttachment::route('/create'),
            'view' => ViewAttachment::route('/{record}'),
            'edit' => EditAttachment::route('/{record}/edit'),
        ];
    }

    public static function getRecordRouteBindingEloquentQuery(): Builder
    {
        return parent::getRecordRouteBindingEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
