<?php

namespace Albedo\Gamification\Contracts;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Carbon;

interface PeriodContract
{
    public static function getNameColumn(): string;

    public static function getStartColumn(): string;

    public static function getEndColumn(): string;

    public static function getPeriodByDate(Carbon $dateTime): ?PeriodContract;

    public static function getCurrent(): ?PeriodContract;

    public static function getPreviousCurrent(): ?PeriodContract;

    public static function getActive(): ?PeriodContract;

    public function isCurrent(): bool;

    public function getSelectName(): string;

    public function getStartDate(): Carbon;

    public function getEndDate(): Carbon;
}
