<?php

namespace Albedo\Gamification\Database\Factories;

use Albedo\Gamification\Models\Faq;
use Albedo\Gamification\Models\FaqItem;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Carbon;

class FaqItemFactory extends Factory
{
    protected $model = FaqItem::class;

    public function definition(): array
    {
        return [
            'question' => $this->faker->word(),
            'answer' => $this->faker->word(),
            'is_active' => $this->faker->boolean(),
            'order' => $this->faker->randomNumber(),
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),

            'faq_id' => Faq::factory(),
        ];
    }
}
