<?php

namespace Albedo\Gamification\Services;

use Albedo\Auth\Services\User;
use Albedo\Gamification\Models\Agreement;
use Albedo\Gamification\Models\Document;

class AgreementService
{
    public static function prepareAgreementsList(): array
    {
        $documents = Document::all();
        $agreements = Agreement::all();

        $agreementResponse = [];

        foreach ($agreements as $agreement) {
            $agreementResponse[$agreement->name] = [
                'must_be_accepted' => $agreement->required,
                'text' => $agreement->parsed_text,
                'label' => $agreement->label,
            ];
        }
        return $agreementResponse;
    }

    public function saveAgreementsForUser(User $user, array $agreements): void
    {
        $user->update([
            'agreements' => $agreements
        ]);
    }
}
