<?php

namespace Albedo\Gamification\Models;

use App\Models\Traits\Uuid;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Model;

class Agreement extends Model
{
    protected $guarded = [];

    public function parsedText(): Attribute
    {
        return Attribute::make(
            get: fn() => $this->parse($this->text)
        );
    }

    private function parse(string $text): string
    {
        $agreements = ProgramFile::with(['media', 'fileType'])
            ->get();

        $links = $agreements
            ->mapWithKeys(fn(ProgramFile $programFile) => [
                $programFile->fileType->slug => $programFile->url
                    ?: $programFile->getFirstMediaUrl('rule')
            ])
            ->toArray();

        $pattern = '/\[([^\]]+)\]\(\s*\{\{\s*([^}\s]+)\s*\}\}\s*\)/u';

        return preg_replace_callback($pattern, function ($m) use ($links) {
            $text = $m[1];
            $key = $m[2];

            $href = $links[$key] ?? '#';

            $labelEsc = htmlspecialchars($text, ENT_QUOTES, 'UTF-8');
            $hrefEsc = htmlspecialchars($href, ENT_QUOTES, 'UTF-8');

            return "<a data-target=\"_blank\" href=\"{$hrefEsc}\">{$labelEsc}</a>";
        }, $text);
    }
}
