<?php

namespace Albedo\Gamification\Models;

use App\Models\Scopes\IsActiveScope;
use App\Models\User;
use App\Traits\Uuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;

class Avatar extends Model implements HasMedia
{
    use InteractsWithMedia;

    protected $guarded = [];

    public function users(): HasMany
    {
        return $this->hasMany(User::class);
    }


}
