<?php

namespace Albedo\Gamification;

use Albedo\Gamification\Exceptions\GamificationExceptionHandler;
use Illuminate\Contracts\Debug\ExceptionHandler;
use Illuminate\Support\Facades\Response;
use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;

class GamificationServiceProvider extends PackageServiceProvider
{
    public static string $name = 'gamification';

    public function configurePackage(Package $package): void
    {
        $package
            ->name(static::$name)
            ->hasMigrations([
                '2022_12_14_083707_create_settings_table',
                '2024_12_30_125323_create_documents_table',
                '2024_12_30_125406_create_agreements_table',
                '2025_10_16_000001_create_user_agreements_table',
                '2025_07_17_081035_create_file_types_table',
                '2025_07_17_081051_create_program_files_table',
                '2025_10_07_115712_create_media_table',
                '2025_07_02_123455_create_avatars_table',
                '2025_10_18_221947_create_user_avatars_table',
                '2025_10_24_085539_create_point_category_table',
                '2025_01_28_143743_create_points_table',
                '2025_11_25_095045_create_rule_contents_table',
                '2025_11_25_130123_create_faqs_table',
                '2025_11_25_132831_create_faq_items_table'
            ])
            ->runsMigrations()
            ->hasConfigFile('gamification')
            ->hasRoute('gamification');
    }

    public function bootingPackage()
    {
        $this->app->singleton(ExceptionHandler::class, GamificationExceptionHandler::class);
    }

    public function packageBooted()
    {
        if (!Response::hasMacro('success')) {
            Response::macro('success', function (mixed $data = [], string $message = '', ?array $errors = null, mixed $meta = [], int $status = 200, array $headers = []) {
                $structure = [
                    'status' => __('OK'),
                    'data' => $data,
                    'meta' => $meta,
                    'message' => $message,
                    'errors' => $errors,
                ];

                return Response::json($structure, $status, $headers);
            });
        }

        if (!Response::hasMacro('error')) {
            Response::macro('error', function (mixed $data = [], string $message = '', mixed $meta = [], ?array $errors = null, int $status = 500, array $headers = []) {
                $structure = [
                    'status' => __('Error'),
                    'data' => $data,
                    'meta' => $meta,
                    'message' => $message,
                    'errors' => $errors,
                ];

                return Response::json($structure, $status, $headers);
            });
        }

        if (!Response::hasMacro('generalError')) {
            Response::macro('generalError', function (mixed $data = [], string $message = '', ?array $errors = null, mixed $meta = [], int $status = 500, array $headers = []) {
                $structure = [
                    'status' => __('Error'),
                    'data' => $data,
                    'meta' => $meta,
                    'message' => $message ?? __('An error occurred'),
                    'errors' => $errors,
                ];

                return Response::json($structure, $status, $headers);
            });
        }

    }
}
